<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'vendor/autoload.php'; // Ensure Composer's autoloader is included
require 'db_connect.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

// Decode JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Check if the input is valid JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input']);
    exit;
}

// Validate required fields
$required_fields = ['email', 'name', 'password', 'phonenumber'];
foreach ($required_fields as $field) {
    if (empty($input[$field])) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit;
    }
}

$email = $conn->real_escape_string($input['email']);
$name = $conn->real_escape_string($input['name']);
$password = password_hash($input['password'], PASSWORD_BCRYPT);
$phonenumber = $conn->real_escape_string($input['phonenumber']);
$status = 0; // default status to 0 (not verified)

// Ensure 'phone_number' matches your table schema
$sql = "INSERT INTO users (email, name, password, status, phone_number) VALUES ('$email', '$name', '$password', '$status', '$phonenumber')";

if ($conn->query($sql) === TRUE) {
    $verification_link = "https://gove.co.in/carrier_jobs/verify.php?email=$email";

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'chopdaankita6@gmail.com'; // Your Gmail email
        $mail->Password = 'bbvf zulc vxoc cgcq'; // Your Gmail password or App-specific password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('chopdaankita6@gmail.com', 'Carrier Jobs');
        $mail->addAddress($email);

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Verify Your Email Address';
        $mail->Body    = "Please click on the following link to verify your email address: <a href='$verification_link'>$verification_link</a>";

        $mail->send();
        echo json_encode(['status' => 'success', 'message' => 'Registration successful, please check your email to verify your account.']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => "Message could not be sent. Mailer Error: {$mail->ErrorInfo}"]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error: ' . $conn->error]);
}

$conn->close();
?>
