<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'db_connect.php';

header('Content-Type: application/json');

// Decode JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Check if the input is valid JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input']);
    exit;
}

// Validate required fields
if (empty($input['email']) || empty($input['password'])) {
    echo json_encode(['status' => 'error', 'message' => 'Email and password are required.']);
    exit;
}

$email = $conn->real_escape_string($input['email']);
$password = $input['password'];

// Check if the email exists and retrieve the hashed password and user ID
$sql = "SELECT id, password, status FROM users WHERE email='$email'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if ($row['status'] == 0) {
        echo json_encode(['status' => 'error', 'message' => 'Account not verified.']);
        exit;
    }

    // Verify the password
    if (password_verify($password, $row['password'])) {
        echo json_encode([
            'status' => 'success', 
            'message' => 'Login successful',
            'userid' => $row['id']
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
}

$conn->close();
?>
