<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
require 'db_connect.php';

// Set the content type to application/json
header('Content-Type: application/json');

// Get the raw POST data
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// Check if JSON decoding succeeded
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid JSON input: " . json_last_error_msg()
    ]);
    exit;
}

// Check for required fields
$required_fields = ['additional_details', 'category', 'date', 'details', 'isLive', 'job_location', 'job_name', 'sharing_data'];
foreach ($required_fields as $field) {
    if (!isset($data[$field])) {
        echo json_encode([
            "status" => "error",
            "message" => "Missing required field: $field"
        ]);
        exit;
    }
}

// Get POST data
$additional_details = $data['additional_details'];
$category = $data['category'];
$date = $data['date'];
$details = $data['details'];
$isLive = $data['isLive'];
$job_location = $data['job_location'];
$job_name = $data['job_name'];
$sharing_data = $data['sharing_data'];

// Prepare and bind
$stmt = $conn->prepare("INSERT INTO jobs (additional_details, category, date, details, isLive, job_location, job_name, sharing_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "Prepare failed: " . $conn->error
    ]);
    exit;
}
$stmt->bind_param("ssssssss", $additional_details, $category, $date, $details, $isLive, $job_location, $job_name, $sharing_data);

// Execute the statement
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Job posting added successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
}

// Close connections
$stmt->close();
$conn->close();
?>
