<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
require 'db_connect.php';

// Set the content type to application/json
header('Content-Type: application/json');

// Get page from the request, default to 1 if not provided
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page_size = 20; // Fixed page size

// Calculate the offset
$offset = ($page - 1) * $page_size;

// Query to get the total number of jobs
$total_jobs_query = "SELECT COUNT(*) AS total_jobs FROM jobs";
$total_jobs_result = $conn->query($total_jobs_query);
$total_jobs = $total_jobs_result->fetch_assoc()['total_jobs'];

// Calculate total number of pages
$total_pages = ceil($total_jobs / $page_size);

// Query to get jobs with pagination
$sql = "SELECT * FROM jobs ORDER BY STR_TO_DATE(date, '%d/%m/%Y %H:%i:%s') DESC LIMIT $page_size OFFSET $offset";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $jobs = array();
    while ($row = $result->fetch_assoc()) {
        // Convert numeric values to strings if needed
        foreach ($row as $key => $value) {
            $row[$key] = strval($value); // Ensure all values are strings
        }
        $jobs[] = $row;
    }

    // Query to get counts for specific categories
    $category_counts = array(
        "offshore" => "0",  // Initialize as string
        "oil_and_gas" => "0",  // Initialize as string
        "renewable_energy" => "0"  // Initialize as string
    );

    $category_queries = array(
        "offshore" => "SELECT COUNT(*) AS count FROM jobs WHERE category LIKE '%Offshore%'",
        "oil_and_gas" => "SELECT COUNT(*) AS count FROM jobs WHERE category LIKE '%Oil and Gas%'",
        "renewable_energy" => "SELECT COUNT(*) AS count FROM jobs WHERE category LIKE '%Renewable Energy%'"
    );

    foreach ($category_queries as $category => $query) {
        $category_result = $conn->query($query);
        if ($category_result->num_rows > 0) {
            $cat_row = $category_result->fetch_assoc();
            $category_counts[$category] = strval($cat_row['count']); // Ensure count is a string
        }
    }

    // Query to get count for Gulf Middle East countries
    $gulf_countries = array('Saudi Arabia', 'UAE', 'Kuwait', 'Qatar', 'Oman', 'Bahrain', 'Iran');
    $gulf_count_query = "SELECT COUNT(*) AS gulf_count FROM jobs 
                         WHERE job_location IN ('" . implode("', '", $gulf_countries) . "')";
    $gulf_count_result = $conn->query($gulf_count_query);
    $gulf_count = $gulf_count_result->fetch_assoc()['gulf_count'];

    // Ensure gulf_count is a string
    $gulf_count = strval($gulf_count);

    // Construct final response
    $response = array(
        "status" => "success",
        "total_jobs" => strval($total_jobs),
        "total_pages" => strval($total_pages),
        "page" => strval($page),
        "offshore" => $category_counts['offshore'],
        "oil_and_gas" => $category_counts['oil_and_gas'],
        "renewable_energy" => $category_counts['renewable_energy'],
        "gulf_middle_east" => $gulf_count,
        "data" => $jobs
    );

    echo json_encode($response);
} else {
    echo json_encode(["status" => "error", "message" => "No jobs found"]);
}

// Close the connection
$conn->close();
?>
