<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
require 'db_connect.php';

// Set the content type to application/json
header('Content-Type: application/json');

// Query to get the total number of jobs
$total_jobs_query = "SELECT COUNT(*) AS total_jobs FROM jobs";
$total_jobs_result = $conn->query($total_jobs_query);
$total_jobs = $total_jobs_result->fetch_assoc()['total_jobs'];

// Query to get all jobs ordered by date in descending order
$sql = "SELECT * FROM jobs ORDER BY STR_TO_DATE(date, '%d/%m/%Y %H:%i:%s') DESC";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $jobs = array();
    while ($row = $result->fetch_assoc()) {
        // Convert numeric values to strings if needed
        foreach ($row as $key => $value) {
            $row[$key] = strval($value); // Ensure all values are strings
        }
        $jobs[] = $row;
    }

    // Construct final response
    $response = array(
        "status" => "success",
        "total_jobs" => strval($total_jobs),
        "data" => $jobs
    );

    echo json_encode($response);
} else {
    echo json_encode(["status" => "error", "message" => "No jobs found"]);
}

// Close the connection
$conn->close();
?>
