<?php
$pageTitle = "My Account | Career Nest";
include_once __DIR__ . '/../../components/frontend/header.php';
?>

<?php
include_once __DIR__ . '/../../config/dbcon.php';

$userId = $_SESSION['user_id'] ?? 0;


$sql = "
    SELECT 
        *
    FROM users 
    WHERE id = :user_id
    AND deleted_at IS NULL

";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
$stmt->execute();
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$sql = "
    SELECT 
        sj.id AS saved_id,
        sj.created_at,
        j.id AS job_id,
        j.job_name,
        c.city_name AS city_name
    FROM saved_jobs sj
    JOIN jobs j ON j.id = sj.job_id
    LEFT JOIN cities c ON c.id = j.city_id
    WHERE sj.user_id = :user_id
    AND j.deleted_at IS NULL
    ORDER BY sj.created_at DESC

";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
$stmt->execute();
$savedJobs = $stmt->fetchAll(PDO::FETCH_ASSOC);

$jobSql = "
    SELECT 
       *
    FROM jobs 
    WHERE created_by = :user_id
    AND deleted_at IS NULL
    ORDER BY created_at DESC
";

$jobStmt = $conn->prepare($jobSql);
$jobStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
$jobStmt->execute();
$myJobs = $jobStmt->fetchAll(PDO::FETCH_ASSOC);

$categorySql = "
    SELECT * FROM categories WHERE deleted_at IS NULL ORDER BY category_name ASC
";

$categoryStmt = $conn->prepare($categorySql);
$categoryStmt->execute();
$categories = $categoryStmt->fetchAll(PDO::FETCH_ASSOC);

$stateSql = "
    SELECT * FROM states WHERE deleted_at IS NULL ORDER BY state_name ASC
";

$stateStmt = $conn->prepare($stateSql);
$stateStmt->execute();
$states = $stateStmt->fetchAll(PDO::FETCH_ASSOC);

$citySql = "
    SELECT * FROM cities WHERE deleted_at IS NULL ORDER BY city_name ASC
";

$cityStmt = $conn->prepare($citySql);
$cityStmt->execute();
$cities = $cityStmt->fetchAll(PDO::FETCH_ASSOC);

$countrySql = "
    SELECT * FROM countries WHERE deleted_at IS NULL ORDER BY country_name ASC
";

$countryStmt = $conn->prepare($countrySql);
$countryStmt->execute();
$countries = $countryStmt->fetchAll(PDO::FETCH_ASSOC);

$countrySql = "
    SELECT * FROM countries WHERE deleted_at IS NULL ORDER BY country_name ASC
";

$countryStmt = $conn->prepare($countrySql);
$countryStmt->execute();
$countries = $countryStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="account-dashboard-section">
    <div class="container">
        <div class="row">

            <!-- LEFT SIDEBAR -->
            <div class="col-lg-3 mb-4">

                <!-- PROFILE CARD -->
                <div class="profile-card">
                    <div class="profile-card-body">

                        <div class="profile-img-wrapper">
                            <img src="<?=
                                !empty($_SESSION['profile_image'])
                                ? ($_ENV['BASE_URL'] ?? $baseURL) . '/uploads/profile/' . $_SESSION['profile_image']
                                : (
                                    !empty($user['profile'])
                                    ? ($_ENV['BASE_URL'] ?? $baseURL) . '/uploads/profile/' . $user['profile']
                                    : ($baseURL . '/assets/img/default-avatar.png')
                                )
                                ?>" alt="Profile" class="profile-img">

                            <button class="camera-btn" onclick="document.getElementById('profile-upload').click();">
                                <i class="fa fa-camera"></i>
                            </button>
                            <input type="file" id="profile-upload" style="display: none;" accept="image/*">
                        </div>

                        <h5 class="profile-name">
                            <?= htmlspecialchars($_SESSION['user_name'] ?? 'Guest User') ?>
                        </h5>

                        <span class="profile-role-badge">
                            <?php
                            $role = $_SESSION['role'] ?? 'user';
                            echo ucfirst($role);
                            ?>
                        </span>

                    </div>
                </div>

                <!-- SIDEBAR MENU -->
                <div class="sidebar-menu-card">
                    <div class="card-body p-3">
                        <ul class="account-sidebar">

                            <li class="list-group-item active" data-target="account">
                                <i class="fa fa-user"></i>
                                <span>Account Settings</span>
                            </li>

                            <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'employee'): ?>
                                <li class="list-group-item" data-target="post-job">
                                    <i class="fa fa-briefcase"></i>
                                    <span>Post a Job</span>
                                </li>
                            <?php endif; ?>

                            <li class="list-group-item" data-target="saved-jobs">
                                <i class="fa fa-heart"></i>
                                <span>Saved Jobs</span>
                            </li>

                            <li class="list-group-item text-danger" id="logoutBtn">
                                <i class="fa fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </li>

                        </ul>
                    </div>
                </div>

            </div>

            <!-- RIGHT CONTENT AREA -->
            <div class="col-lg-9">

                <div class="content-card">
                    <div class="content-card-body">

                        <!-- Account Settings -->
                        <div class="content-section" id="account">
                            <?php include_once __DIR__ . '/profile.php'; ?>
                        </div>

                        <!-- Post Job -->
                        <div class="content-section d-none" id="post-job">
                            <?php include_once __DIR__ . '/job-post.php'; ?>
                        </div>

                        <!-- Saved Jobs -->
                        <div class="content-section d-none" id="saved-jobs">
                            <?php include_once __DIR__ . '/saved-job.php'; ?>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>

    <!-- Logout Confirmation Modal -->
    <div class="modal fade modern-modal delete-modal" id="logoutConfirmModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fa fa-right-from-bracket"></i>
                        Confirm Logout
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body text-center">
                    <i class="fa fa-right-from-bracket d-block"></i>
                    <p>Are you sure you want to logout?</p>
                    <small class="text-muted">You'll need to login again to access your account.</small>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light px-4" data-bs-dismiss="modal">
                        <i class="fa fa-times me-2"></i>
                        Cancel
                    </button>
                    <button type="button" class="btn btn-danger px-4" id="confirmLogoutBtn">
                        <i class="fa fa-right-from-bracket me-2"></i>
                        Logout
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>


<?php
include_once __DIR__ . '/../../components/frontend/footer.php';
?>