<div class="jobs-header">
    <h4 class="jobs-title">
        <i class="fa fa-briefcase"></i>
        My Jobs
    </h4>
    <button class="btn-add-job" data-bs-toggle="modal" data-bs-target="#addJobModal">
        <i class="fa fa-plus"></i>
        Add Job
    </button>
</div>

<div class="table-card">
    <table class="jobs-table">
        <thead>
            <tr>
                <th style="width:60px;">Id</th>
                <th>Job Title</th>
                <th>Salary</th>
                <th>Vaccency</th>
                <th>Expiry</th>
                <th>Featured</th>
                <th style="width:110px;">Action</th>
            </tr>
        </thead>

        <tbody>
            <?php if (!empty($myJobs)): ?>
                <?php foreach ($myJobs as $index => $job): ?>
                    <tr>
                        <td class="row-number"><?= $index + 1 ?></td>

                        <td>
                            <?= htmlspecialchars($job['job_name']) ?>
                        </td>

                        <td>
                            <span class="badge-custom badge-salary">
                                <?= htmlspecialchars($job['job_salary']) ?>
                            </span>
                        </td>

                        <td>
                            <span class="badge-custom badge-positions">
                                <?= htmlspecialchars($job['job_available_positions']) ?>
                            </span>
                        </td>

                        <td>
                            <span class="badge-custom badge-expiry">
                                <?= date('d M Y', strtotime($job['expiry_date'])) ?>
                            </span>
                        </td>

                        <td>
                            <?= $job['is_featured']
                                ? '<span class="badge-custom badge-featured-yes">Yes</span>'
                                : '<span class="badge-custom badge-featured-no">No</span>' ?>
                        </td>

                        <td>
                            <div class="action-buttons">
                                <button class="btn-action btn-edit edit-job-btn" data-bs-toggle="modal"
                                    data-bs-target="#editJobModal" data-id="<?= $job['id'] ?>"
                                    data-name="<?= htmlspecialchars($job['job_name'], ENT_QUOTES, 'UTF-8') ?>"
                                    data-type="<?= htmlspecialchars($job['job_type'], ENT_QUOTES, 'UTF-8') ?>"
                                    data-description="<?= htmlspecialchars_decode($job['job_description'], ENT_QUOTES) ?>"
                                    data-salary="<?= htmlspecialchars($job['job_salary'], ENT_QUOTES, 'UTF-8') ?>"
                                    data-positions="<?= htmlspecialchars($job['job_available_positions'], ENT_QUOTES, 'UTF-8') ?>"
                                    data-category="<?= $job['category_id'] ?>" data-country="<?= $job['country_id'] ?>"
                                    data-state="<?= $job['state_id'] ?>" data-city="<?= $job['city_id'] ?>"
                                    data-expiry="<?= date('Y-m-d', strtotime($job['expiry_date'])) ?>"
                                    data-featured="<?= $job['is_featured'] ?>"
                                    data-apply="<?= htmlspecialchars_decode($job['apply'], ENT_QUOTES) ?>" title="Edit Job">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn-action btn-delete" title="Delete" onclick="deleteJob(<?= $job['id'] ?>)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="empty-state">
                        <i class="fa fa-briefcase"></i>
                        <p>No jobs posted yet</p>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Add Job Modal -->
<div class="modal fade modern-modal" id="addJobModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" style="color:white;">
                    <i class="fa fa-plus-circle"></i>
                    Add New Job
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form method="POST" action="<?= $baseURL ?>/api/frontend/add-job.php" id="addJobForm" novalidate>
                <div class="modal-body">
                    <div class="row g-3">

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-briefcase"></i>
                                Job Name
                            </label>
                            <input type="text" name="job_name" class="form-control" placeholder="e.g. Senior Developer"
                                required>
                            <div class="invalid-feedback">Job name is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-clock"></i>
                                Job Type
                            </label>
                            <select name="job_type" class="form-select" required>
                                <option value="">Select Job Type</option>
                                <option value="full_time">Full Time</option>
                                <option value="part_time">Part Time</option>
                                <option value="intern">Intern</option>
                            </select>
                            <div class="invalid-feedback">Job type is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-dollar-sign"></i>
                                Salary
                            </label>
                            <input type="text" name="salary" class="form-control" placeholder="e.g. $50,000 - $70,000"
                                required>
                            <div class="invalid-feedback">Salary is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-users"></i>
                                Available Positions
                            </label>
                            <input type="number" name="positions" class="form-control" placeholder="e.g. 3" required>
                            <div class="invalid-feedback">Available positions is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-tags"></i>
                                Category
                            </label>
                            <select name="category_id" class="form-select" required>
                                <option value="">Select Category</option>
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?= $category['id'] ?>">
                                        <?= htmlspecialchars($category['category_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">Category is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-globe"></i>
                                Country
                            </label>
                            <select name="country_id" id="add_country_id" class="form-select" required>
                                <option value="">Select Country</option>
                                <?php foreach ($countries as $country): ?>
                                    <option value="<?= $country['id'] ?>">
                                        <?= htmlspecialchars($country['country_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">Country is required</div>
                        </div>

                        <div class="col-md-6" id="addState">
                            <label class="form-label">
                                <i class="fa fa-map"></i>
                                State
                            </label>
                            <select name="state_id" id="add_state_id" class="form-select" required>
                                <option value="">Select State</option>
                                <?php foreach ($states as $state): ?>
                                    <option value="<?= $state['id'] ?>">
                                        <?= htmlspecialchars($state['state_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">State is required</div>
                        </div>

                        <div class="col-md-6" id="addCity">
                            <label class="form-label">
                                <i class="fa fa-location-dot"></i>
                                City
                            </label>
                            <select name="city_id" id="add_city_id" class="form-select" required>
                                <option value="">Select City</option>
                                <?php foreach ($cities as $city): ?>
                                    <option value="<?= $city['id'] ?>">
                                        <?= htmlspecialchars($city['city_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">City is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-calendar"></i>
                                Expiry Date
                            </label>
                            <input type="date" name="expiry_date" class="form-control" required>
                            <div class="invalid-feedback">Expiry date is required</div>
                        </div>

                        <div class="col-12">
                            <label class="form-label">
                                <i class="fa fa-file-lines"></i>
                                Job Description
                            </label>
                            <textarea name="description" id="job_description" class="form-control"
                                placeholder="Describe the job role, responsibilities, and requirements..."
                                required></textarea>
                            <div class="invalid-feedback">Minimum 10 characters required</div>
                        </div>

                        <div class="col-12">
                            <label class="form-label">
                                <i class="fa fa-paper-plane"></i>
                                How to Apply
                            </label>
                            <textarea name="apply" id="job_apply" class="form-control"
                                placeholder="Provide application instructions..." required></textarea>
                            <div class="invalid-feedback">Minimum 10 characters required</div>
                        </div>

                        <div class="col-12 form-check form-switch mb-10" style="padding-left: 51px;">
                            <input class="form-check-input" type="checkbox" name="is_featured" value="1"
                                id="add_featured">
                            <label class="form-check-label" for="add_featured">
                                <i class="fa fa-star"></i>
                                Mark as Featured Job
                            </label>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" name="add_job" class="btn btn-primary">
                        <i class="fa fa-plus me-2"></i>
                        Add Job
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>


<!-- Edit Job Modal -->
<div class="modal fade modern-modal" id="editJobModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fa fa-edit"></i>
                    Edit Job
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form method="POST" action="<?= $baseURL ?>/api/frontend/edit-job.php" id="editJobForm" novalidate>
                <input type="hidden" name="job_id" id="edit_job_id">

                <div class="modal-body">
                    <div class="row g-3">

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-briefcase"></i>
                                Job Name
                            </label>
                            <input type="text" name="job_name" id="edit_job_name" class="form-control" required>
                            <div class="invalid-feedback">Job name is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-clock"></i>
                                Job Type
                            </label>
                            <select name="job_type" id="edit_job_type" class="form-select" required>
                                <option value="">Select Job Type</option>
                                <option value="full_time">Full Time</option>
                                <option value="part_time">Part Time</option>
                                <option value="intern">Intern</option>
                            </select>
                            <div class="invalid-feedback">Job type is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-dollar-sign"></i>
                                Salary
                            </label>
                            <input type="text" name="salary" id="edit_salary" class="form-control" required>
                            <div class="invalid-feedback">Salary is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-users"></i>
                                Available Positions
                            </label>
                            <input type="number" name="positions" id="edit_positions" class="form-control" required>
                            <div class="invalid-feedback">Available positions is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-tags"></i>
                                Category
                            </label>
                            <select name="category_id" id="edit_category_id" class="form-select" required>
                                <option value="">Select Category</option>
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?= $category['id'] ?>">
                                        <?= htmlspecialchars($category['category_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">Category is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-globe"></i>
                                Country
                            </label>
                            <select name="country_id" id="edit_country_id" class="form-select" required>
                                <option value="">Select Country</option>
                                <?php foreach ($countries as $country): ?>
                                    <option value="<?= $country['id'] ?>">
                                        <?= htmlspecialchars($country['country_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">Country is required</div>
                        </div>

                        <div class="col-md-6" id="editState">
                            <label class="form-label">
                                <i class="fa fa-map"></i>
                                State
                            </label>
                            <select name="state_id" id="edit_state_id" class="form-select" required>
                                <option value="">Select State</option>
                                <?php foreach ($states as $state): ?>
                                    <option value="<?= $state['id'] ?>">
                                        <?= htmlspecialchars($state['state_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">State is required</div>
                        </div>

                        <div class="col-md-6" id="editCity">
                            <label class="form-label">
                                <i class="fa fa-location-dot"></i>
                                City
                            </label>
                            <select name="city_id" id="edit_city_id" class="form-select" required>
                                <option value="">Select City</option>
                                <?php foreach ($cities as $city): ?>
                                    <option value="<?= $city['id'] ?>">
                                        <?= htmlspecialchars($city['city_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">City is required</div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">
                                <i class="fa fa-calendar"></i>
                                Expiry Date
                            </label>
                            <input type="date" name="expiry_date" id="edit_expiry_date" class="form-control" required>
                            <div class="invalid-feedback">Expiry date is required</div>
                        </div>

                        <div class="col-12">
                            <label class="form-label">
                                <i class="fa fa-file-lines"></i>
                                Job Description
                            </label>
                            <textarea name="description" id="edit_description" class="form-control" required></textarea>
                            <div class="invalid-feedback">Minimum 10 characters required</div>
                        </div>

                        <div class="col-12">
                            <label class="form-label">
                                <i class="fa fa-paper-plane"></i>
                                How to Apply
                            </label>
                            <textarea name="apply" id="edit_apply" class="form-control" required></textarea>
                            <div class="invalid-feedback">Minimum 10 characters required</div>
                        </div>

                        <div class="col-12 form-check form-switch" style="padding-left: 51px;">
                            <input class="form-check-input" type="checkbox" name="is_featured" id="edit_is_featured"
                                value="1">
                            <label class="form-check-label" for="edit_is_featured">
                                <i class="fa fa-star"></i>
                                Mark as Featured Job
                            </label>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" name="update_job" class="btn btn-primary">
                        <i class="fa fa-check me-2"></i>
                        Update Job
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>


<!-- Delete Confirmation Modal -->
<div class="modal fade modern-modal delete-modal" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fa fa-triangle-exclamation"></i>
                    Confirm Deletion
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body text-center">
                <i class="fa fa-trash-can d-block"></i>
                <p>
                    Are you sure you want to delete this job?
                </p>
                <small class="text-muted">
                    This action can be undone if you are using soft delete.
                </small>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-light px-4" data-bs-dismiss="modal">
                    <i class="fa fa-times me-2"></i>
                    Cancel
                </button>
                <button type="button" class="btn btn-danger px-4" id="confirmDeleteBtn">
                    <i class="fa fa-trash me-2"></i>
                    Delete
                </button>
            </div>

        </div>
    </div>
</div>
<script>
    let deleteJobId = null;

    function deleteJob(jobId) {
        deleteJobId = jobId;

        const modal = new bootstrap.Modal(
            document.getElementById("deleteConfirmModal")
        );
        modal.show();
    }

    document.getElementById("confirmDeleteBtn").addEventListener("click", function () {
        if (!deleteJobId) return;

        fetch(`${window.BASE_URL}/api/frontend/delete-job.php`, {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ job_id: deleteJobId }),
            credentials: "same-origin",
        })
            .then(res => res.json())
            .then(data => {
                showToast(data.success ? "success" : "error", data.message);

                setTimeout(() => {
                    location.reload();
                }, 1200);
            })
            .catch(() => {
                showToast("error", "Something went wrong");
            });

        // Close modal
        bootstrap.Modal.getInstance(
            document.getElementById("deleteConfirmModal")
        ).hide();

        deleteJobId = null;
    });

    const editModal = document.getElementById("editJobModal");

    editModal.addEventListener("show.bs.modal", function (event) {
        const btn = event.relatedTarget;

        document.getElementById("edit_job_id").value = btn.dataset.id;
        document.getElementById("edit_job_name").value = btn.dataset.name;
        document.getElementById("edit_job_type").value = btn.dataset.type;
        document.getElementById("edit_salary").value = btn.dataset.salary;
        document.getElementById("edit_positions").value = btn.dataset.positions;
        document.getElementById("edit_category_id").value = btn.dataset.category;
        document.getElementById("edit_country_id").value = btn.dataset.country;
        document.getElementById("edit_state_id").value = btn.dataset.state;
        document.getElementById("edit_city_id").value = btn.dataset.city;
        document.getElementById("edit_expiry_date").value = btn.dataset.expiry;

        document.getElementById("edit_is_featured").checked =
            btn.dataset.featured === "1";

        $("#edit_description").summernote("code", btn.dataset.description);
        $("#edit_apply").summernote("code", btn.dataset.apply);
    });


</script>