<?php
$pageTitle = "Home | Career Nest";
include_once __DIR__ . '/../../components/frontend/header.php';
?>

<?php
include_once __DIR__ . '/../../config/dbcon.php';

$userId = $_SESSION['user_id'] ?? null; // current logged-in user
$jobId = (int) $_GET['id'];

// Fetch job details
$sql = "
    SELECT 
        j.*,
        c.city_name AS location
    FROM jobs j
    LEFT JOIN cities c ON c.id = j.city_id
    WHERE j.id = :job_id
      AND j.deleted_at IS NULL
    LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bindValue(':job_id', $jobId, PDO::PARAM_INT);
$stmt->execute();

$job = $stmt->fetch(PDO::FETCH_ASSOC);

if ($job === false) {
    header("Location: jobs.php");
    exit;
}

// Check if the job is saved by this user
$isSaved = false;

if ($userId) {
    $stmt = $conn->prepare("SELECT 1 FROM saved_jobs WHERE user_id = :user_id AND job_id = :job_id LIMIT 1");
    $stmt->execute(['user_id' => $userId, 'job_id' => $jobId]);

    if ($stmt->fetchColumn()) {
        $isSaved = true;
    }
}

$isApplied = false;
if ($userId) {
    $stmt = $conn->prepare("SELECT 1 FROM applied_jobs WHERE user_id = :user_id AND job_id = :job_id LIMIT 1");
    $stmt->execute(['user_id' => $userId, 'job_id' => $jobId]);

    if ($stmt->fetchColumn()) {
        $isApplied = true;
    }
}
?>

<section class="job-details-section">
    <div class="container">

        <!-- Breadcrumb -->
        <div class="row">
            <div class="col">
                <nav aria-label="breadcrumb" class="breadcrumb-container">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="<?= $baseURL ?>/view/frontend/job.php">
                                <i class="fa fa-arrow-left"></i> Back to Jobs
                            </a>
                        </li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Main Content -->
        <div class="row">

            <!-- Job Details -->
            <div class="col-md-8">
                <div class="job-details-card">

                    <!-- Job Header -->
                    <div class="job-details-header">
                        <form id="addToFav" method="POST" action="add-to-fav.php">
                            <input type="hidden" name="job_id" value="<?= $job['id'] ?>">
                            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?? '' ?>">

                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <h1 class="job-title-main">
                                        <?= htmlspecialchars($job['job_name']) ?>
                                    </h1>

                                    <div class="job-meta-header">
                                        <span class="job-meta-badge">
                                            <i class="fa fa-map-marker-alt"></i>
                                            <?= htmlspecialchars($job['location']) ?>
                                        </span>
                                        <span class="job-meta-badge">
                                            <i class="fa fa-clock"></i>
                                            <?= ucwords(str_replace('_', ' ', $job['job_type'])) ?>
                                        </span>
                                    </div>
                                </div>

                                <!-- Favorite Button -->
                                <?php
                                $isFav = in_array($job['id'], $userFavourites ?? []);
                                ?>
                                <button type="submit" class="btn-favorite <?= $isFav ? 'active' : '' ?>">
                                    <i class="fa fa-heart"></i>
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Job Content -->
                    <div class="job-content-wrapper">
                        <div class="job-section">
                            <h4 class="job-section-title">Job Description</h4>
                            <div class="job-content">
                                <?= $job['job_description'] ?>
                            </div>
                        </div>

                        <div class="job-section">
                            <h4 class="job-section-title">Who Can Apply</h4>
                            <div class="job-section-content">
                                <p><?= $job['apply'] ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="job-actions">
                        <?php if (isset($_SESSION['user_id'])): ?>

                            <?php if ($isSaved): ?>
                                <a href="javascript:void(0);" onclick="unSaveJob(<?= $job['id'] ?>)" class="btn btn-unsave">
                                    <i class="fa fa-times-circle me-2"></i> Unsave
                                </a>
                            <?php else: ?>
                                <a href="javascript:void(0);" onclick="saveJob(<?= $job['id'] ?>)" class="btn btn-save">
                                    <i class="fa fa-bookmark me-2"></i> Save Job
                                </a>
                            <?php endif; ?>

                            <?php if ($isApplied): ?>
                                <button class="btn btn-applied" disabled>
                                    <i class="fa fa-check me-2"></i> Already Applied
                                </button>
                            <?php else: ?>
                                <a href="#" onclick="jobApply(<?= $job['id'] ?>)" class="btn btn-apply">
                                    <i class="fa fa-paper-plane me-2"></i> Apply Now
                                </a>
                            <?php endif; ?>

                        <?php else: ?>

                            <a href="#" data-bs-toggle="modal" data-bs-target="#loginModal" class="btn btn-login">
                                <i class="fa fa-sign-in me-2"></i> Login to Apply
                            </a>

                        <?php endif; ?>
                    </div>

                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-md-4">

                <!-- Job Summary -->
                <div class="sidebar-card">
                    <h4 class="sidebar-title">
                        <i class="fa fa-briefcase"></i> Job Summary
                    </h4>
                    <ul class="sidebar-list">
                        <li>
                            <strong>Published:</strong>
                            <span><?= date('d M, Y', strtotime($job['created_at'])) ?></span>
                        </li>
                        <li>
                            <strong>Vacancy:</strong>
                            <span><?= $job['job_available_positions'] ?>
                                Position<?= $job['job_available_positions'] > 1 ? 's' : '' ?></span>
                        </li>
                        <li>
                            <strong>Salary:</strong>
                            <span><?= htmlspecialchars($job['job_salary']) ?></span>
                        </li>
                        <li>
                            <strong>Location:</strong>
                            <span><?= htmlspecialchars($job['location']) ?></span>
                        </li>
                        <li>
                            <strong>Job Type:</strong>
                            <span><?= ucwords(str_replace('_', ' ', $job['job_type'])) ?></span>
                        </li>
                    </ul>
                </div>

                <!-- Company Details -->
                <div class="sidebar-card">
                    <h4 class="sidebar-title">
                        <i class="fa fa-building"></i> Company Details
                    </h4>
                    <ul class="sidebar-list">
                        <li>
                            <strong>Name:</strong>
                            <span><?= htmlspecialchars($job['company_name'] ?? 'Dummy Company') ?></span>
                        </li>
                        <li>
                            <strong>Location:</strong>
                            <span><?= htmlspecialchars($job['company_location'] ?? 'N/A') ?></span>
                        </li>
                        <li>
                            <strong>Website:</strong>
                            <?php if (!empty($job['company_website']) && $job['company_website'] !== 'N/A'): ?>
                                <a href="<?= htmlspecialchars($job['company_website']) ?>" target="_blank" rel="noopener">
                                    Visit Website <i class="fa fa-external-link-alt ms-1"></i>
                                </a>
                            <?php else: ?>
                                <span>N/A</span>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>

            </div>

        </div>
    </div>
</section>


<?php
include_once __DIR__ . '/../../components/frontend/footer.php';
?>