<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
    $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
    $stmt->execute([':uid' => $_SESSION['user_uid']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "User";
$pageHeading = "User";
?>
<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php'; ?>
<?php
$query = "SELECT * FROM users WHERE role = 'user' AND deleted_at IS NULL ORDER BY created_at DESC";
$stmt = $conn->prepare($query);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="main-wrapper">
    <div class="page-header">
        <h2 class="page-title">User List</h2>

    </div>
    <div class="modern-table-card mt-3">
        <div class="table-responsive-wrapper">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Profile</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($users)): ?>
                        <?php foreach ($users as $index => $user): ?>
                            <tr>
                                <td data-label="#"><?= $index + 1 ?></td>

                                <td data-label="Profile">
                                    <img src="<?= (!empty($user['profile']) && file_exists(__DIR__ . '/../../../uploads/profile/' . $user['profile']))
                                        ? '../../../uploads/profile/' . htmlspecialchars($user['profile'])
                                        : '../../../assets/img/default-avatar-icon.png' ?>" width="40" height="40"
                                        class="rounded-circle" alt="<?= htmlspecialchars($user['name']) ?>">
                                <td data-label="Name">
                                    <?= htmlspecialchars($user['name']) ?>
                                </td>
                                </td>
                                <td data-label="Email">
                                    <?= htmlspecialchars($user['email']) ?>
                                </td>


                                <td data-label="Phone">
                                    <?= htmlspecialchars($user['phone']) ?>
                                </td>


                                <td data-label="Action">


                                    <?php if ((int) $user['is_blocked'] === 1): ?>
                                        <!-- Unblock User -->
                                        <button class="btn btn-sm btn-success me-1"
                                            style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                            title="Unblock User" onclick="unblockUser(<?= (int) $user['id'] ?>)">
                                            <i class="fas fa-unlock"></i>
                                        </button>
                                    <?php else: ?>
                                        <!-- Block User -->
                                        <button class="btn btn-sm btn-outline-primary me-1"
                                            style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                            title="Block User" onclick="blockUser(<?= (int) $user['id'] ?>)">
                                            <i class="fas fa-ban"></i>
                                        </button>
                                    <?php endif; ?>


                                    <!-- Delete User -->
                                    <button class="btn btn-sm btn-outline-danger"
                                        style="width:36px;height:36px;display:inline-flex;align-items:center;justify-content:center;"
                                        title="Delete User" onclick="deleteUser(<?= (int) $user['id'] ?>)">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>

                                </td>

                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No jobs found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>

<?php include __DIR__ . '/../../../components/backend/footer.php'; ?>