<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
  $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
  $stmt->execute([':uid' => $_SESSION['user_uid']]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "State";
$pageHeading = "State";
?>

<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php'; ?>

<?php
$query = "
    SELECT 
        states.id,
        states.country_id,
        states.state_name AS stateName,
        countries.country_name
    FROM states
    INNER JOIN countries 
        ON states.country_id = countries.id
    WHERE states.deleted_at IS NULL
      AND countries.deleted_at IS NULL
    ORDER BY states.id DESC
";

$stmt = $conn->prepare($query);
$stmt->execute();
$states = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("SELECT id, country_name 
        FROM countries 
        WHERE deleted_at IS NULL 
        ORDER BY country_name ASC
    ");
$stmt->execute();
$countries = $stmt->fetchAll(PDO::FETCH_ASSOC);


?>


<div class="custom-toast-container" id="toastContainer"></div>

<div class="main-wrapper">
  <div class="page-header">
    <h2 class="page-title">State List</h2>
    <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addStateModal">
      Add State
    </a>
  </div>

  <div class="modern-table-card mt-3">
    <div class="table-responsive-wrapper">
      <table class="modern-table">
        <thead>
          <tr>
            <th>Id</th>
            <th>Country Name</th>
            <th>State Name</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($states)): ?>
            <?php foreach ($states as $index => $state): ?>
              <tr>
                <td data-label="#"><?= $index + 1 ?></td>

                <td data-label="Country Name">
                  <?= htmlspecialchars($state['country_name']) ?>
                </td>

                <td data-label="state Name">
                  <?= htmlspecialchars($state['stateName']) ?>
                </td>


                <td data-label="Action">
                  <button class="btn btn-sm btn-outline-primary me-1"
                    style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                    title="Edit State" onclick="EditState(
                                                <?= $state['id'] ?>,
                                                '<?= htmlspecialchars($state['country_id'], ENT_QUOTES) ?>',
                                                '<?= htmlspecialchars($state['stateName'], ENT_QUOTES) ?>'
                                            )">
                    <i class="fas fa-edit"></i>
                  </button>

                  <!-- Delete Button -->
                  <button class="btn btn-sm btn-outline-danger"
                    style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                    title="Delete State" onclick="DeleteState(<?= $state['id'] ?>)">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="4" class="text-center">No States found</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- ================= ADD STATE MODAL ================= -->
  <div class="modal fade" id="addStateModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title">Add State</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form id="addStateForm" enctype="multipart/form-data" novalidate>

            <!-- COUNTRY -->
            <div class="mb-3">
              <label class="form-label">Country</label>
              <select name="country_id" id="countryId" class="form-control" required>
                <option value="">-- Select Country --</option>
                <?php foreach ($countries as $country): ?>
                  <option value="<?= $country['id'] ?>">
                    <?= htmlspecialchars($country['country_name']) ?>
                  </option>
                <?php endforeach; ?>
              </select>
              <div class="invalid-feedback" id="state-country-error"></div>
            </div>

            <!-- STATE NAME -->
            <div class="mb-3">
              <label class="form-label">State Name</label>
              <input type="text" class="form-control" name="state_name" id="stateName" placeholder="Enter State name"
                required>
              <div class="invalid-feedback" id="state-name-error"></div>
            </div>

            <div class="d-flex gap-2">
              <button type="submit" class="btn btn-primary w-50">Add State</button>
              <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
            </div>

          </form>
        </div>

      </div>
    </div>
  </div>


  <!-- ================= EDIT STATE MODAL ================= -->
  <div class="modal fade" id="editStateModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title">Edit State</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form id="editStateForm" enctype="multipart/form-data" novalidate>

            <input type="hidden" name="id" id="edit_state_id">

            <!-- COUNTRY -->
            <div class="mb-3">
              <label class="form-label">Country</label>
              <select name="country_id" id="edit_country_id" class="form-control" required>
                <option value="">-- Select Country --</option>
                <?php foreach ($countries as $country): ?>
                  <option value="<?= $country['id'] ?>">
                    <?= htmlspecialchars($country['country_name']) ?>
                  </option>
                <?php endforeach; ?>
              </select>
              <div class="invalid-feedback" id="edit-state-country-error"></div>
            </div>

            <!-- STATE NAME -->
            <div class="mb-3">
              <label>State Name</label>
              <input type="text" class="form-control" name="state_name" id="edit_state_name" required>
              <div class="invalid-feedback" id="edit-state-name-error"></div>
            </div>

            <div class="d-flex gap-2">
              <button type="submit" class="btn btn-primary w-50">Update State</button>
              <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">
                Cancel
              </button>
            </div>

          </form>
        </div>

      </div>
    </div>
  </div>

  <?php include __DIR__ . '/../../../components/backend/footer.php'; ?>