<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
  $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
  $stmt->execute([':uid' => $_SESSION['user_uid']]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "Country";
$pageHeading = "Country";
?>

<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php';

$query = "SELECT * FROM countries WHERE is_deleted = 0 ORDER BY id DESC";
$stmt = $conn->prepare($query);
$stmt->execute();
$countries = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="custom-toast-container" id="toastContainer"></div>

<div class="main-wrapper">
  <div class="page-header">
    <h2 class="page-title">Country List</h2>
    <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCountryModal">
      Add Country
    </a>
  </div>
  <div class="modern-table-card mt-3">
    <div class="table-responsive-wrapper">
      <table class="modern-table">
        <thead>
          <tr>
            <th>Id</th>
            <th>Country Name</th>
            <th>Country Currency</th>
            <th>Country Code</th>
            <th>Image</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($countries)): ?>
            <?php foreach ($countries as $index => $country): ?>
              <tr>
                <td data-label="#"><?= $index + 1 ?></td>
                <td data-label="Country Name"><?= htmlspecialchars($country['country_name']) ?></td>
                <td data-label="Country Currency"><?= htmlspecialchars($country['country_currency'] ?? 'N/A') ?>
                </td>
                <td data-label="Country Code"><?= htmlspecialchars($country['country_code'] ?? 'N/A') ?></td>
                <td data-label="Country">
                  <div class="country-cell">
                    <img src="<?= (!empty($country['country_icon']) && file_exists(__DIR__ . '/../../../uploads/country_icon/' . $country['country_icon']))
                      ? '../../../uploads/country_icon/' . htmlspecialchars($country['country_icon'])
                      : '../../../assets/img/default-country-icon.png' ?>" width="40" height="40"
                      class="rounded-circle" alt="<?= htmlspecialchars($country['country_name']) ?>">
                  </div>
                </td>
                <td data-label="Action">
                  <a href="#" class="btn btn-sm btn-outline-primary me-1"
                    style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                    title="Edit Country" onclick="EditCountry(
                                            <?= $country['id'] ?>,
                                            '<?= htmlspecialchars($country['country_name'], ENT_QUOTES) ?>',
                                            '<?= htmlspecialchars($country['country_currency'], ENT_QUOTES) ?>',
                                            '<?= htmlspecialchars($country['country_code'], ENT_QUOTES) ?>',
                                            '<?= htmlspecialchars($country['country_icon'], ENT_QUOTES) ?>'
                                        )">
                    <i class="fas fa-edit"></i>
                  </a>

                  <!-- Delete Button -->
                  <a href="#" class="btn btn-sm btn-outline-danger"
                    style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                    title="Delete Country" onclick="DeleteCountry(<?= $country['id'] ?>)">
                    <i class="fas fa-trash-alt"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="4" class="text-center">No countries found</td>
            </tr>
          <?php endif; ?>
        </tbody>

      </table>
    </div>
  </div>

  <!-- Add Country Modal -->
  <div class="modal fade" id="addCountryModal" tabindex="-1" aria-labelledby="addCountryLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title" id="addCountryLabel">Add Country</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form id="addCountryForm" enctype="multipart/form-data" novalidate>

            <!-- COUNTRY NAME -->
            <div class="mb-3">
              <label class="form-label">Country Name</label>
              <input type="text" class="form-control" name="country_name" id="countryName"
                placeholder="Enter country name" required>
              <div class="invalid-feedback" id="country-name-error"></div>
            </div>

            <!-- COUNTRY CURRENCY -->
            <div class="mb-3">
              <label class="form-label">Country Currency</label>
              <input type="text" class="form-control" name="country_currency" id="countryCurrency"
                placeholder="Enter country currency" required>
              <div class="invalid-feedback" id="country-currency-error"></div>
            </div>

            <!-- COUNTRY CODE -->
            <div class="mb-3">
              <label class="form-label">Country Code</label>
              <input type="number" class="form-control" name="country_code" id="countryCode"
                placeholder="Enter country code" required>
              <div class="invalid-feedback" id="country-code-error"></div>
            </div>

            <!-- COUNTRY IMAGE -->
            <div class="mb-3">
              <label class="form-label">Country Image</label>

              <input type="file" id="c_image" name="country_image" class="form-control" accept="image/*">


              <div class="mt-3">
                <img id="imagePreview" src="<?= '../../../assets/img/default-country-icon.png' ?>" alt="Preview"
                  style="width:80px;height:80px;object-fit:cover;border-radius:6px;border:1px solid #ddd;">
              </div>
            </div>

            <div class="d-flex gap-2">
              <button type="submit" class="btn btn-primary w-50">Add Country</button>
              <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Update Country Modal -->
  <div class="modal fade" id="editCountryModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title">Edit Country</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form id="editCountryForm" enctype="multipart/form-data" novalidate>

            <input type="hidden" name="id" id="edit_country_id">

            <!-- COUNTRY NAME -->
            <div class="mb-3">
              <label>Country Name</label>
              <input type="text" class="form-control" name="name" id="edit_name" required>
              <div class="invalid-feedback" id="edit-country-name-error"></div>
            </div>

            <!-- COUNTRY CURRENCY -->
            <div class="mb-3">
              <label>Country Currency</label>
              <input type="text" class="form-control" name="currency" id="edit_currency" required>
              <div class="invalid-feedback" id="edit-country-currency-error"></div>
            </div>

            <!-- COUNTRY CODE -->
            <div class="mb-3"></div>
            <label>Country Code</label>
            <input type="number" class="form-control" name="code" id="edit_code" required>
            <div class="invalid-feedback" id="edit-country-code-error"></div>
        </div>

        <!-- COUNTRY IMAGE -->
        <div class="mb-3">
          <label>Country Image</label>
          <input type="file" id="c_image1" name="country_image" class="form-control" accept="image/*">
          <div class="invalid-feedback" id="edit-country-image-error"></div>

          <div class="mt-3">
            <img id="imagePreview1" src="<?= '../../../assets/img/default-country-icon.png' ?>" alt="Preview"
              style="width:80px;height:80px;object-fit:cover;border-radius:6px;border:1px solid #ddd;">
          </div>
        </div>

        <div class="d-flex gap-2">
          <button type="submit" class="btn btn-primary w-50">Update Country</button>
          <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
        </div>

        </form>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../../components/backend/footer.php'; ?>