<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
    $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
    $stmt->execute([':uid' => $_SESSION['user_uid']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "Citiy";
$pageHeading = "Citiy";
?>

<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php'; ?>

<?php
$query = "
    SELECT 
        cities.id,
        cities.state_id,
        cities.city_name AS cityName,
        states.state_name
    FROM cities
    INNER JOIN states 
        ON cities.state_id = states.id
    WHERE cities.deleted_at IS NULL
      AND states.deleted_at IS NULL
    ORDER BY cities.id DESC
";

$stmt = $conn->prepare($query);
$stmt->execute();
$cities = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("SELECT id, state_name 
        FROM states 
        WHERE deleted_at IS NULL 
        ORDER BY state_name ASC
    ");
$stmt->execute();
$states = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="custom-toast-container" id="toastContainer"></div>

<div class="main-wrapper">
    <div class="page-header">
        <h2 class="page-title">City List</h2>
        <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCityModal">
            Add City
        </a>
    </div>

    <div class="modern-table-card mt-3">
        <div class="table-responsive-wrapper">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>State Name</th>
                        <th>City Name</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($cities)): ?>
                        <?php foreach ($cities as $index => $city): ?>
                            <tr>
                                <td data-label="#"><?= $index + 1 ?></td>

                                <td data-label="State Name">
                                    <?= htmlspecialchars($city['state_name']) ?>
                                </td>

                                <td data-label="City Name">
                                    <?= htmlspecialchars($city['cityName']) ?>
                                </td>


                                <td data-label="Action">
                                    <button class="btn btn-sm btn-outline-primary me-1"
                                        style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                        title="Edit City" onclick="EditCity(
                                                <?= $city['id'] ?>,
                                                '<?= htmlspecialchars($city['state_id'], ENT_QUOTES) ?>',
                                                '<?= htmlspecialchars($city['cityName'], ENT_QUOTES) ?>'
                                            )">
                                        <i class="fas fa-edit"></i>
                                    </button>

                                    <!-- Delete Button -->
                                    <button class="btn btn-sm btn-outline-danger"
                                        style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                        title="Delete City" onclick="DeleteCity(<?= $city['id'] ?>)">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">No Cities found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ================= ADD City MODAL ================= -->
    <div class="modal fade" id="addCityModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Add City</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="addCityForm" enctype="multipart/form-data" novalidate>

                        <!-- COUNTRY -->
                        <div class="mb-3">
                            <label class="form-label">State</label>
                            <select name="state_id" id="stateId" class="form-control" required>
                                <option value="">-- Select State --</option>
                                <?php foreach ($states as $state): ?>
                                    <option value="<?= $state['id'] ?>">
                                        <?= htmlspecialchars($state['state_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback" id="city-state-error"></div>
                        </div>

                        <!-- CITY NAME -->
                        <div class="mb-3">
                            <label class="form-label">City Name</label>
                            <input type="text" class="form-control" name="city_name" id="cityName"
                                placeholder="Enter City name" required>
                            <div class="invalid-feedback" id="city-name-error"></div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">Add City</button>
                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- ================= EDIT STATE MODAL ================= -->
    <div class="modal fade" id="editCityModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Edit State</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="editCityForm" enctype="multipart/form-data" novalidate>

                        <input type="hidden" name="id" id="edit_city_id">

                        <!-- STATE -->
                        <div class="mb-3">
                            <label class="form-label">State</label>
                            <select name="state_id" id="edit_state_id" class="form-control" required>
                                <option value="">-- Select State --</option>
                                <?php foreach ($states as $state): ?>
                                    <option value="<?= $state['id'] ?>">
                                        <?= htmlspecialchars($state['state_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback" id="edit-city-state-error"></div>
                        </div>

                        <!-- CITY NAME -->
                        <div class="mb-3">
                            <label>City Name</label>
                            <input type="text" class="form-control" name="city_name" id="edit_city_name" required>
                            <div class="invalid-feedback" id="edit-city-name-error"></div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">Update City</button>
                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include __DIR__ . '/../../../components/backend/footer.php'; ?>