<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
    $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
    $stmt->execute([':uid' => $_SESSION['user_uid']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "Category";
$pageHeading = "Category";
?>

<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php'; ?>

<?php
$query = "SELECT * FROM categories WHERE deleted_at IS NULL ORDER BY id DESC";
$stmt = $conn->prepare($query);
$stmt->execute();
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="custom-toast-container" id="toastContainer"></div>

<div class="main-wrapper">
    <div class="page-header">
        <h2 class="page-title">Category List</h2>
        <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
            Add Category
        </a>
    </div>

    <div class="modern-table-card mt-3">
        <div class="table-responsive-wrapper">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Category Name</th>
                        <th>Image</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($categories)): ?>
                        <?php foreach ($categories as $index => $category): ?>
                            <tr>
                                <td data-label="#"><?= $index + 1 ?></td>

                                <td data-label="Category Name">
                                    <?= htmlspecialchars($category['category_name']) ?>
                                </td>

                                <td data-label="Image">
                                    <img src="<?= (!empty($category['category_image']) && file_exists(__DIR__ . '/../../../uploads/category_icon/' . $category['category_image']))
                                        ? '../../../uploads/category_icon/' . htmlspecialchars($category['category_image'])
                                        : '../../../assets/img/default-category-icon.png' ?>" width="40" height="40"
                                        class="rounded-circle" alt="<?= htmlspecialchars($category['category_name']) ?>">
                                </td>

                                <td data-label="Action">
                                    <button class="btn btn-sm btn-outline-primary me-1"
                                        style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                        title="Edit Category" onclick="EditCategory(
                                                <?= $category['id'] ?>,
                                                '<?= htmlspecialchars($category['category_name'], ENT_QUOTES) ?>',
                                                '<?= htmlspecialchars($category['category_image'], ENT_QUOTES) ?>'
                                            )">
                                        <i class="fas fa-edit"></i>
                                    </button>

                                    <!-- Delete Button -->
                                    <button class="btn btn-sm btn-outline-danger"
                                        style="width: 36px; height: 36px; display: inline-flex; align-items: center; justify-content: center;"
                                        title="Delete Category" onclick="DeleteCategory(<?= $category['id'] ?>)">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">No categories found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ================= ADD CATEGORY MODAL ================= -->
    <div class="modal fade" id="addCategoryModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Add Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="addCategoryForm" enctype="multipart/form-data" novalidate>

                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" id="category_name" name="category_name" class="form-control">
                            <!-- ERROR -->
                            <div class="invalid-feedback" id="category-name-error"></div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Category Image</label>

                            <input type="file" id="c_image2" name="category_image" class="form-control" accept="image/*"
                                data-preview="categoryImagePreview">

                            <!-- ERROR -->
                            

                            <!-- Preview Box -->
                            <div class="mt-3">
                                <img id="imagePreview2" src="<?= '../../../assets/img/default-category-icon.png' ?>"
                                    alt="Preview"
                                    style="width: 80px; height: 80px; object-fit: cover; border-radius: 6px; border: 1px solid #ddd;">
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">Add Category</button>
                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
    <!-- ================= EDIT CATEGORY MODAL ================= -->
    <div class="modal fade" id="editCategoryModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Edit Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="editCategoryForm" enctype="multipart/form-data" novalidate>

                        <input type="hidden" name="id" id="edit_category_id">

                        <!-- CATEGORY NAME -->
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" name="category_name" id="edit_category_name" class="form-control"
                                required>
                            <div class="invalid-feedback" id="edit-category-name-error"></div>
                        </div>

                        <!-- CATEGORY IMAGE -->
                        <div class="mb-3">
                            <label class="form-label">Category Image</label>
                            <input type="file" id="c_image3" name="category_image" class="form-control"
                                accept="image/*">
                            <div class="invalid-feedback" id="edit-category-image-error"></div>

                            <!-- Preview -->
                            <div class="mt-3">
                                <img id="imagePreview3" src="" alt="Preview"
                                    style="width:80px;height:80px;object-fit:cover;border-radius:6px;border:1px solid #ddd;">
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">
                                Update Category
                            </button>

                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">
                                Cancel
                            </button>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>

    <?php include __DIR__ . '/../../../components/backend/footer.php'; ?>