<?php
$page_title = "Login";
ob_start();
?>
<div class="row">

    <!-- LEFT IMAGE -->
    <div class="col-12 col-lg-6 p-0">
        <div class="form-img h-100">
            <img src="assets/img/login.jpg" class="w-100 h-100 object-fit-cover" />
        </div>
    </div>

    <!-- RIGHT CONTENT -->
    <div class="col-12 col-lg-6 d-flex align-items-center">

        <div class="form-con p-4 w-100">

            <h2 class="title mb-4">Sign In</h2>

            <form class="needs-validation" id="login-form" novalidate>

                <!-- EMAIL -->
                <div class="mb-3">
                    <label class="form-label">Email address</label>
                    <input type="email" class="form-control" id="login-email" placeholder="Enter email"
                        value="<?= $_SESSION['remember_email'] ?? '' ?>" required>
                    <div class="invalid-feedback" id="login-email-error"></div>
                </div>

                <!-- PASSWORD -->
                <div class="mb-4">
                    <label class="form-label">Password</label>
                    <input type="password" class="form-control" id="login-password" placeholder="Enter password"
                        required>
                    <div class="invalid-feedback" id="login-password-error"></div>
                </div>

                <!-- FORGOT PASSWORD LINK -->
                <div class="mb-3 d-flex justify-content-between align-items-center">
                    <!-- Left side: Forgot Password link -->
                    <a href="forgot-password.php" class="text-primary fw-semibold">Forgot Password?</a>

                    <!-- Right side: Remember Me checkbox -->
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="1" id="rememberMe">
                        <label class="form-check-label" for="rememberMe">
                            Remember Me
                        </label>
                    </div>
                </div>

                <button type="submit" id="login-btn" class="btn btn-primary w-100 mb-2">Sign In</button>


            </form>

            <p class="mt-3 text-center">
                Don't have an account?
                <a href="register.php" class="text-primary fw-semibold">Sign Up</a>
            </p>

        </div>
    </div>

</div>
<?php
$content = ob_get_clean();
include 'common/center-card.php';
?>