<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle : 'Job Admin Panel'; ?></title>

    <?php $baseURL = "http://localhost/carrier_job_admin"; ?>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= $baseURL ?>/assets/bootstrap/css/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.6/r-2.4.1/datatables.min.css">

    <!-- Summernote CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= $baseURL ?>/assets/css/main.css">
</head>

<body>

    <!-- Header -->
    <div class="header">
        <!-- Mobile Menu Toggle -->
        <button class="mobile-toggle" id="mobileMenu" onclick="openMobileSidebar()" aria-label="Open menu">
            <i class="fas fa-bars"></i>
        </button>

        <!-- Page Title -->
        <h4 class="breadcrumb-title">
            <?php echo isset($pageHeading) ? "Home > " . $pageHeading : 'Admin Panel'; ?>
        </h4>

        <!-- Profile Dropdown -->
        <div class="profile-dropdown">
            <div class="profile-toggle">
                <img src="<?= !empty($user['profile'])
                    ? $baseURL . '/uploads/profile/' . $user['profile']
                    : $baseURL . '/assets/img/default-avatar-icon.png' ?>" alt="Profile" class="profile-avatar">

                <span class="profile-name">
                    <?php echo htmlspecialchars($user['name'] ?? 'Admin'); ?>
                </span>

                <span class="arrow">
                    <i class="fa-solid fa-chevron-down"></i>
                </span>
            </div>

            <div class="dropdown-menu">
                <a href="javascript:void(0)" class="item" data-bs-toggle="modal" data-bs-target="#profileModal">
                    <i class="fa-solid fa-user icon blue"></i>
                    Profile
                </a>

                <a href="javascript:void(0)" class="item" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                    <i class="fa-solid fa-key icon yellow"></i>
                    Change Password
                </a>

                <div class="divider"></div>

                <a href="/carrier_job_admin/logout.php" class="item logout">
                    <i class="fa-solid fa-right-from-bracket icon red"></i>
                    Logout
                </a>
            </div>
        </div>
    </div>

    <!-- Profile Modal -->
    <div class="modal fade" id="profileModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">My Profile</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <form id="profileForm" enctype="multipart/form-data">
                    <div class="modal-body">

                        <input type="hidden" name="admin_id"
                            value="<?php echo isset($_SESSION['user_uid']) ? $_SESSION['user_uid'] : ''; ?>">

                        <!-- Profile Image -->
                        <div class="text-center mb-3">
                            <img id="profilePreview" src="<?= !empty($user['profile'])
                                ? $baseURL . '/uploads/profile/' . $user['profile']
                                : $baseURL . '/assets/img/default-avatar-icon.png' ?>" class="rounded-circle mb-2"
                                width="100" height="100" style="object-fit: cover;">
                            <div>
                                <input type="file" name="profile_image" id="profileImage"
                                    class="form-control form-control-sm" accept="image/*">
                            </div>
                        </div>

                        <!-- Name -->
                        <div class="mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" value="<?= htmlspecialchars($user['name'] ?? '') ?>"
                                class="form-control" required>
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" value="<?= htmlspecialchars($user['email'] ?? '') ?>"
                                class="form-control" required>
                        </div>

                        <!-- Phone -->
                        <div class="mb-3">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone" value="<?= htmlspecialchars($user['phone'] ?? '') ?>"
                                class="form-control" required>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Profile</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Change Password Modal -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Change Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <form id="changePasswordForm">
                    <div class="modal-body">

                        <input type="hidden" id="admin_id"
                            value="<?php echo isset($_SESSION['user_uid']) ? $_SESSION['user_uid'] : ''; ?>">
                        <!-- New Password -->
                        <div class="mb-3">
                            <label class="form-label">New Password</label>
                            <input type="password" class="form-control" id="new_password" required>
                            <div class="invalid-feedback" id="new-password-error"></div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="mb-3">
                            <label class="form-label">Confirm Password</label>
                            <input type="password" class="form-control" id="confirm_password" required>
                            <div class="invalid-feedback" id="confirm-password-error"></div>
                        </div>

                        <div class="text-danger small d-none" id="passwordError">
                            Passwords do not match
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Update Password
                        </button>
                    </div>
                </form>

            </div>
        </div>
    </div>