<?php
try {

    header("Content-Type: application/json");

    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
        exit;
    }

    $id = $_POST['id'] ?? null;
    $countryId = $_POST['country_id'] ?? null;
    $stateName = $_POST['state_name'] ?? null;


    if (!$id) {
        sendResponse(400, "id is required");
        exit;
    }

    if (!$countryId && !$stateName) {
        sendResponse(400, "Country Name  or State Name is required");
        exit;
    }


    if ($stateName !== null) {

        $stmt = $conn->prepare(
            "UPDATE states SET country_id = ?, state_name = ? WHERE id = ? AND deleted_at IS NULL"
        );
        $stmt->execute([$countryId, $stateName, $id]);
    }
    sendResponse(200, "State updated successfully");
    exit;

} catch (PDOException $e) {
    sendResponse(500, "Server Error");
    exit;
}
