<?php
try {
    header("Content-Type: application/json");

    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $countryId = $_POST['country_id'] ?? null;
    $stateName = trim($_POST['state_name'] ?? '');

    if (!$countryId || !$stateName) {
        sendResponse(400, "Country and State name are required");
    }

    $stmt = $conn->prepare(
        "INSERT INTO states (country_id, state_name) VALUES (?, ?)"
    );

    $stmt->execute([$countryId, $stateName]);

    sendResponse(200, "State added successfully");

} catch (PDOException $e) {
    sendResponse(500, $e->getMessage()); // show error while debugging
}
