<?php
try {

    header("Content-Type: application/json");
    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $input = json_decode(file_get_contents("php://input"), true);


    $id = $_POST['id'] ?? null;
    if (empty($id)) {
        sendResponse(400, "Job id is required");
    }

    $stmt = $conn->prepare("SELECT * FROM jobs WHERE id = ? AND deleted_at IS NULL");
    $stmt->execute([$id]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$existing) {
        sendResponse(404, "Job not found");
    }

    $job_name = $_POST['job_name'] ?? null;
    $job_type = $_POST['job_type'] ?? null;
    $job_description = $_POST['job_description'] ?? null;
    $job_salary = $_POST['job_salary'] ?? null;
    $job_positions = $_POST['available_positions'] ?? null;
    $apply = $_POST['how_to_apply'] ?? null;
    $is_featured = isset($_POST['is_featured']) ? 1 : 0;
    $country_id = $_POST['country_id'] ?? null;
    $state_id = $_POST['state_id'] ?? null;
    $city_id = $_POST['city_id'] ?? null;
    $category_id = $_POST['category_id'] ?? null;
    $expiry_date = $_POST['expiry_date'] ?? null;

    if (
        $job_name === null &&
        $job_type === null &&
        $job_description === null &&
        $job_salary === null &&
        $job_positions === null &&
        $apply === null &&
        $is_featured === null &&
        $country_id === null &&
        $state_id === null &&
        $city_id === null &&
        $category_id === null &&
        $expiry_date === null
    ) {
        sendResponse(400, "At least one field is required for update");
    }
    $job_name = $job_name ?? $existing['job_name'];
    $job_type = $job_type ?? $exis0ting['job_type'];
    $job_description = $job_description ?? $existing['job_description'];
    $job_salary = $job_salary ?? $existing['job_salary'];
    $job_positions = $job_positions ?? $existing['job_available_positions'];
    $apply = $apply ?? $existing['apply'];
    $is_featured = $is_featured ?? $existing['is_featured'];
    $country_id = $country_id ?? $existing['country_id'];
    $state_id = $state_id ?? $existing['state_id'];
    $city_id = $city_id ?? $existing['city_id'];
    $category_id = $category_id ?? $existing['category_id'];
    $expiry_date = $expiry_date ?? $existing['expiry_date'];

    if (!empty($country_id)) {

        $stmt = $conn->prepare("SELECT country_name FROM countries WHERE id = ? AND deleted_at IS NULL");
        $stmt->execute([$country_id]);
        $country = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$country) {
            sendResponse(400, "Invalid country");
        }

        $country_name = strtolower($country['country_name']);

        if ($country_name === 'india' && (empty($state_id) || empty($city_id))) {
            sendResponse(400, "State and City are required for India");
        }
    }
    $stmt = $conn->prepare("
        UPDATE jobs SET
            job_name = ?,
            job_type = ?,
            job_description = ?,
            job_salary = ?,
            job_available_positions = ?,
            apply = ?,
            is_featured = ?,
            country_id = ?,
            state_id = ?,
            city_id = ?,
            category_id = ?,
            expiry_date = ?,
            updated_at = NOW()
        WHERE id = ?
    ");

    $stmt->execute([
        $job_name,
        $job_type,
        $job_description,
        $job_salary,
        $job_positions,
        $apply,
        $is_featured,
        $country_id,
        $state_id,
        $city_id,
        $category_id,
        $expiry_date,
        $id
    ]);

    sendResponse(200, "Job updated successfully");

} catch (PDOException $e) {
    sendResponse(500, "Server Error");
}
?>