    <?php
    try {
        header("Content-Type: application/json");
        include_once dirname(__DIR__, 2) . "/config/dbcon.php";
        include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            sendResponse(405, "Method Not Allowed");
        }

        $input = json_decode(file_get_contents("php://input"), true);

        // Job data
        $job_id = $input['job_id'] ?? null;      // <-- For update
        $job_name = $input['job_name'] ?? null;
        $job_type = $input['job_type'] ?? null;
        $job_description = $input['description'] ?? null;
        $job_salary = $input['job_salary'] ?? null;
        $job_positions = $input['job_positions'] ?? null;
        $job_category_id = $input['category_id'] ?? null;
        $apply = $input['apply'] ?? null;
        $is_featured = $input['is_featured'] ?? 0;
        $country_id = $input['country_id'] ?? null;
        $state_id = $input['state_id'] ?? null;
        $city_id = $input['city_id'] ?? null;
        $expiry_date = $input['expiry_date'] ?? null;

        // Auto expiry date if empty
        if (empty($expiry_date)) {
            $expiry_date = (new DateTime('+1 month'))->format('Y-m-d H:i:s');
        }

        // Validate required fields
        if (
            !$job_name || !$job_type || !$job_description ||
            !$job_salary || !$job_positions || !$apply || !$country_id || !$job_category_id
        ) {
            sendResponse(400, "All fields are required");
        }

        validateFeild($job_name, "Job name");
        validateFeild($job_type, "Job type");
        validateFeild($job_description, "Job description");
        validateFeild($job_salary, "Job salary");
        validatePositiveNumber($job_positions, "Job positions");
        validateFeild($apply, "Apply details");
        validateFeild($country_id, "Country");
        validateFeild($job_category_id, "Job category");

        // Fetch country name to check state & city requirement
        $stmt = $conn->prepare("SELECT country_name FROM countries WHERE id = ? AND deleted_at IS NULL");
        $stmt->execute([$country_id]);
        $country = $stmt->fetch(PDO::FETCH_ASSOC);

        $country_name = strtolower($country['country_name'] ?? '');

        // If country is India, state & city must be provided
        if ($country_name === 'india' && (!$state_id || !$city_id)) {
            sendResponse(400, "State and City are required for India");
        }

        // Validate state exists
        if ($state_id) {
            $stmt = $conn->prepare("SELECT * FROM states WHERE id = ? AND deleted_at IS NULL");
            $stmt->execute([$state_id]);
            if (!$stmt->fetch(PDO::FETCH_ASSOC)) {
                sendResponse(400, "No state found");
            }
        }

        // Validate city exists
        if ($city_id) {
            $stmt = $conn->prepare("SELECT * FROM cities WHERE id = ? AND deleted_at IS NULL");
            $stmt->execute([$city_id]);
            if (!$stmt->fetch(PDO::FETCH_ASSOC)) {
                sendResponse(400, "No city found");
            }
        }

        // Validate category exist
        if ($job_category_id) {
            $stmt = $conn->prepare("SELECT * FROM categories WHERE id = ? AND deleted_at IS NULL");
            $stmt->execute([$job_category_id]);
            if (!$stmt->fetch(PDO::FETCH_ASSOC)) {
                sendResponse(400, "No category found");
            }
        }

        if (!empty($job_id)) {
            $stmt = $conn->prepare("
                UPDATE jobs SET
                    job_name = ?,
                    job_type = ?,
                    job_description = ?,
                    job_salary = ?,
                    job_available_positions = ?,
                    apply = ?,
                    is_featured = ?,
                    country_id = ?,
                    state_id = ?,
                    city_id = ?,
                    category_id = ?,
                    expiry_date = ?,
                    is_published = ?,
                    is_draft = ?,
                    updated_at = NOW()
                WHERE id = ?
            ");

            $stmt->execute([
                $job_name,
                $job_type,
                $job_description,
                $job_salary,
                $job_positions,
                $apply,
                $is_featured,
                $country_id,
                $state_id,
                $city_id,
                $job_category_id,
                $expiry_date,
                1,
                0,
                $job_id,
            ]);

            sendResponse(200, "Job updated successfully");
        }


        $stmt = $conn->prepare("
            INSERT INTO jobs 
            (job_name, job_type, job_description, job_salary, job_available_positions, apply, is_featured, country_id, state_id, city_id, category_id, expiry_date, is_published)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $job_name,
            $job_type,
            $job_description,
            $job_salary,
            $job_positions,
            $apply,
            $is_featured,
            $country_id,
            $state_id,
            $city_id,
            $job_category_id,
            $expiry_date,
            1
        ]);

        sendResponse(201, "Job created successfully");

    } catch (PDOException $e) {
        sendResponse(500, "Server Error");
    }
    ?>