<?php
header('Content-Type: application/json');

session_start();

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'status' => false,
        'message' => 'Invalid request method'
    ]);
    exit;
}

/**
 * Clear session
 */
$_SESSION = [];
session_destroy();

/**
 * Delete session cookie
 */
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

echo json_encode([
    'status' => true,
    'message' => 'Logged out successfully'
]);
exit;
