<?php
include_once __DIR__ . '/../../config/dbcon.php';

header('Content-Type: application/json');

$countryId = $_GET['country_id'] ?? 0;

if (!$countryId) {
    echo json_encode([]);
    exit;
}

$sql = "
    SELECT id, state_name 
    FROM states 
    WHERE country_id = :country_id 
      AND deleted_at IS NULL
    ORDER BY state_name ASC
";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':country_id', $countryId, PDO::PARAM_INT);
$stmt->execute();

$states = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($states);
