<?php
header('Content-Type: application/json');
session_start();

include_once __DIR__ . '/../../config/dbcon.php'; // PDO connection
include_once __DIR__ . '/../../helpers/api_helper.php';

try {
    // Fetch featured and published jobs
    $stmt = $conn->prepare("
       SELECT 
            c.*,
            COUNT(j.id) AS job_count
        FROM countries c
        LEFT JOIN jobs j 
            ON j.country_id = c.id
            AND j.deleted_at IS NULL
            AND j.is_published = 1
        WHERE c.deleted_at IS NULL
        GROUP BY c.id
        ORDER BY c.country_name ASC
    ");

    $stmt->execute();
    $countries = $stmt->fetchAll(PDO::FETCH_ASSOC);

    sendResponse(200, "Countries fetched successfully.", ['countries' => $countries]);

} catch (PDOException $e) {
    sendResponse(500, "Database error: " . $e->getMessage());
}
