<?php
include_once __DIR__ . '/../../config/dbcon.php';

header('Content-Type: application/json');

$stateId = $_GET['state_id'] ?? 0;

if (!$stateId) {
    echo json_encode([]);
    exit;
}

$sql = "
    SELECT id, city_name 
    FROM cities 
    WHERE state_id = :state_id 
      AND deleted_at IS NULL
    ORDER BY city_name ASC
";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':state_id', $stateId, PDO::PARAM_INT);
$stmt->execute();

$cities = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($cities);
