<?php
session_start();
require_once __DIR__ . '/../../config/dbcon.php';
include_once __DIR__ . '/../../helpers/api_helper.php';// where sendResponse exists

header('Content-Type: application/json');

/* 🔐 Auth check */
$userId = $_SESSION['user_id'] ?? 0;
if (!$userId) {
    sendResponse(401, 'Unauthorized access');
}

/* 🧹 Helper */
function clean($value)
{
    return trim(htmlspecialchars($value ?? '', ENT_QUOTES, 'UTF-8'));
}

/* 📥 Inputs */
$category_id = (int) ($_POST['category_id'] ?? 0);
$job_name = clean($_POST['job_name'] ?? '');
$job_type = clean($_POST['job_type'] ?? '');
$job_salary = clean($_POST['salary'] ?? '');
$positions = (int) ($_POST['positions'] ?? 0);
$description = trim($_POST['description'] ?? '');
$apply = trim($_POST['apply'] ?? '');
$country_id = (int) ($_POST['country_id'] ?? 0);
$state_id = $_POST['state_id'] !== '' ? (int) $_POST['state_id'] : null;
$city_id = $_POST['city_id'] !== '' ? (int) $_POST['city_id'] : null;
$expiry_date = $_POST['expiry_date'] !== '' ? $_POST['expiry_date'] : null;
$is_featured = isset($_POST['is_featured']) ? 1 : 0;

/* Draft / Publish */
$is_draft = isset($_POST['save_draft']) ? 1 : 0;
$is_published = $is_draft ? 0 : 1;

/* 🛑 Validation */
if (
    !$category_id ||
    !$job_name ||
    !$job_type ||
    !$job_salary ||
    !$positions ||
    !$country_id
) {
    sendResponse(422, 'All required fields must be filled');
}

if (strlen(strip_tags($description)) < 10) {
    sendResponse(422, 'Job description must be at least 10 characters');
}

if (strlen(strip_tags($apply)) < 10) {
    sendResponse(422, 'How to apply must be at least 10 characters');
}

try {

    $sql = "
        INSERT INTO jobs (
            category_id,
            job_name,
            job_type,
            job_description,
            job_salary,
            job_available_positions,
            apply,
            is_featured,
            country_id,
            state_id,
            city_id,
            expiry_date,
            is_draft,
            is_published,
            created_by
        ) VALUES (
            :category_id,
            :job_name,
            :job_type,
            :job_description,
            :job_salary,
            :positions,
            :apply,
            :is_featured,
            :country_id,
            :state_id,
            :city_id,
            :expiry_date,
            :is_draft,
            :is_published,
            :created_by
        )
    ";

    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':category_id' => $category_id,
        ':job_name' => $job_name,
        ':job_type' => $job_type,
        ':job_description' => $description, // HTML allowed
        ':job_salary' => $job_salary,
        ':positions' => $positions,
        ':apply' => $apply,       // HTML allowed
        ':is_featured' => $is_featured,
        ':country_id' => $country_id,
        ':state_id' => $state_id,
        ':city_id' => $city_id,
        ':expiry_date' => $expiry_date,
        ':is_draft' => $is_draft,
        ':is_published' => $is_published,
        ':created_by' => $userId
    ]);

    $jobId = $conn->lastInsertId();

    sendResponse(
        200,
        'Job added successfully.',
        ['job_id' => $jobId]
    );

} catch (PDOException $e) {
    sendResponse(500, 'Failed to add job. Please try again.');
}
