<?php
try {

    header("Content-Type: application/json");

    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
        exit;
    }

    $id = $_POST['id'] ?? null;
    $stateId = $_POST['state_id'] ?? null;
    $cityName = $_POST['city_name'] ?? null;
    $countryId = $_POST['country_id'] ?? null; // optional if you have country_id

    if (!$id) {
        sendResponse(400, "id is required");
        exit;
    }

    if (!$stateId || !$cityName) {
        sendResponse(400, "State ID and City Name are required");
        exit;
    }

    $stmt = $conn->prepare(
        "UPDATE cities SET state_id = ?, city_name = ? WHERE id = ? AND deleted_at IS NULL"
    );
    $stmt->execute([$stateId, $cityName, $id]);

    sendResponse(200, "City updated successfully");
    exit;

} catch (PDOException $e) {
    // Optional: log error for debugging
    // error_log($e->getMessage());
    sendResponse(500, "Server Error");
    exit;
}

?>