<?php
try {
    header("Content-Type: application/json");

    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");

    }

    $input = json_decode(file_get_contents("php://input"), true);
    $id = $input['id'] ?? null;

    validateFeild($id, "Id");

    $stmt = $conn->prepare("
        SELECT id, city_name 
        FROM cities 
        WHERE state_id = ? 
          AND deleted_at IS NULL 
        ORDER BY city_name ASC, created_at DESC
    ");

    $stmt->execute([$id]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    sendResponse(200, "Cities Get Successfully", $result);
    exit;

} catch (PDOException $e) {
    sendResponse(500, "Server Error");
    exit;
}
?>