<?php
try {
    header("Content-Type: application/json");

    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $input = json_decode(file_get_contents("php://input"), true);
    $id = $_POST['id'] ?? null;

    if (!$id) {
        sendResponse(400, "id is required");
    }

    $stmt = $conn->prepare("
        UPDATE cities
        SET  deleted_at = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$id]);

    sendResponse(200, "City deleted successfully");

} catch (PDOException $e) {
    sendResponse(500, "Server Error");
}
