<?php
try {

    header("Content-Type: application/json");

   
    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $stateId = $_POST['state_id'] ?? null;
    $cityName = $_POST['city_name'] ?? null;


    if (!$stateId || !$cityName) {
        sendResponse(400, "All fields are required");
    }


    if (!$stateId) {
        sendResponse(400, "State Name is required");

    }

    if (!$cityName) {
        sendResponse(400, "City Name is required");

    }

    $stmt = $conn->prepare(
        "INSERT INTO cities (state_id,city_name) VALUES (?,?)"
    );
    $stmt->execute([$stateId, $cityName]);
    sendResponse(200, "City added successfully");
} catch (PDOException $e) {
    sendResponse(500, "Server Error");
}
