<?php

include_once dirname(__DIR__, 2) . "/config/dbcon.php";
include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";
include_once dirname(__DIR__, 2) . "/firebase/firebase_init.php";

try {

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }



    $email = $input['email'] ?? null;

    // Validate email
    if (empty($email)) {
        sendResponse(400, "Email is required");
    }

    // --- Firebase sends the reset email automatically ---
    $auth->sendPasswordResetLink($email);

    sendResponse(200, "Password reset link sent to your email");

} catch (\Kreait\Firebase\Exception\Auth\UserNotFound $e) {

    sendResponse(404, "User not found");

} catch (Exception $e) {

    sendResponse(500, $e->getMessage());

}
